function RollParameters=RollEstimate(d,dPvar)
%	ROLLESTIMATE - RollParameters=RollEstimate(d,dPvar)
[acv, ac] = autoD(d,dPvar,10,0,1);
if acv(2)<0
	RollParameters.HalfSpread = sqrt(-acv(2));
else
	RollParameters.HalfSpread = NaN;
end
RollParameters.Variance = acv(1)+2*acv(2);
RollParameters.SD = sqrt(RollParameters.Variance);
disp('Moment estimates of Roll parameters:');
disp(RollParameters);
